package de.blauerfalke.tetris.control

import java.awt.event.{ActionListener, ActionEvent}
import swing.Dialog
import scala.actors.Actor
import scala.actors.Actor._
import de.blauerfalke.tetris.view.Block
import de.blauerfalke.tetris.view.Stone
import de.blauerfalke.tetris.view.Field
import de.blauerfalke.tetris.view.Main

object Control {
	
}
class Control(val field:Field) {
	var speed = 700
		
	var timer = new javax.swing.Timer(speed , new ActionListener { def actionPerformed(ae:ActionEvent) { Mover ! "down" } })
	timer.start
	
	def nextStone {
		for(c <- field.stone.blocks)
			field.blocks =  Block((field.stone.p._1+c.p._1,field.stone.p._2+c.p._2),c.c) :: field.blocks
				
		var line = Field.fieldHeight
		for(c <- field.blocks) if(c.p._2<line) line = c.p._2
		
		while(line < Field.fieldHeight) {
			var colCount=0
			for(c <- field.blocks)
				if(c.p._2 == line)
						colCount = colCount + 1
							
			if(colCount>=Field.fieldWidth)
				delLine(line)
			else 
				line = line + 1
			
		}
		
		field.stone = Stone(0)
		
		checkGameOver
	}
	
	def delLine(line:Int) {
		field.blocks = field.blocks.filter(s => s.p._2 != line)
		field.blocks = field.blocks.map(s => if(s.p._2<line) Block((s.p._1, s.p._2+1), s.c) else s)
		
	}
	
	def checkGameOver() {
		if(checkCollision) {	//if respawn in a block the game is over ...
			timer.stop
			Dialog.showMessage(field,"GAME OVER\n\nThe Game is over.","Game Over")
			System.exit(0);
		}
	}
	
	def checkCollision() :Boolean = {
		for(b <- field.stone.blocks) {
			val x1 = b.p._1+field.stone.p._1
			val x2 = b.p._2+field.stone.p._2
			if(x1<0 || x1>Field.fieldWidth-1)
				return true
			if(x2<0 || x2>Field.fieldHeight-1)
				return true
			for(c <- field.blocks)
				if(x1==c.p._1 && x2==c.p._2)
					return true
		}
		
		return false
		
	}
	
	val Mover = actor {
		loop {
			react {
				case "left" => { 
					field.stone.left
					if(checkCollision) { 
						field.stone.back
					}
				}
				case "right" => {
					field.stone.right
					if(checkCollision) { 
						field.stone.back
					}
				}
				case "down" => {
					field.stone.down
					if(checkCollision) { 
						field.stone.back
						if(field.stone.ground) {
							nextStone
			     	 	} else {
			     	 		field.stone.ground=true
			     	 	}
					}
				}
				case "turnl" => {
					field.stone.turnl
					if(checkCollision) {
						field.stone.left
						if(checkCollision) {
							field.stone.back
							field.stone.turnr
						}
					}
				}
				case "turnr" => {
					field.stone.turnr
					if(checkCollision) {
						field.stone.left
						if(checkCollision) {
							field.stone.back
							field.stone.turnl
						}
					}
				}
			}
		}

	}
	Mover.start
}