package de.blauerfalke.tetris.control

import java.awt.event.{ActionListener, ActionEvent}
import swing.Dialog
import swing.Swing
import sun.audio._
import java.io.FileInputStream
import scala.actors.Actor
import scala.actors.Actor._
import de.blauerfalke.tetris.view.Block
import de.blauerfalke.tetris.view.Stone
import de.blauerfalke.tetris.view.Field
import de.blauerfalke.tetris.view.Preview
import de.blauerfalke.tetris.view.Main
import de.blauerfalke.tetris.view.DeleteAnimation
import de.blauerfalke.tetris.view.Highscore

object Control {
	
}
class Control(val field:Field) {
	var level = 1
	var speed = 700
	var paused = false
	var running = false
	
	var lines = 0
	var points = 0
	
	var next = Stone(0)
	var preview:Preview = null
	
	var timer = new javax.swing.Timer(speed , new ActionListener { def actionPerformed(ae:ActionEvent) { Mover ! "down" } })
	
	def start() {
		
		level = 1
		speed = 700

		lines = 0
		points = 0
	
		field.stone = Stone(-1)
		field.blocks = List()
				
		next = Stone(0)
		running = true
		
		timer = new javax.swing.Timer(speed , new ActionListener { def actionPerformed(ae:ActionEvent) { Mover ! "down" } })
		timer.start
		
		nextStone
	}
	
	def pause() { pause(!paused) }
	def pause(p:Boolean) {
		paused = p
		if(running) {
			if(paused)
				timer.stop
			else
				timer.start
		}
		
		if(Main.main!=null)
			Main.main.repaint
	}
	def checkLevel() {
		if(lines>level*10)
			levelUp
	}
	def levelUp() {
		
		var as = new AudioStream(this.getClass.getResourceAsStream("/de/blauerfalke/tetris/res/snd/03.wav")); 
		AudioPlayer.player.start(as);    
		
		level = level + 1
		speed = (0.75*speed).asInstanceOf[Int]
		
		if(running) {
			timer.stop
			timer = new javax.swing.Timer(speed , new ActionListener { def actionPerformed(ae:ActionEvent) { Mover ! "down" } })
			timer.start
		}
	}
		
	def nextStone {
		if(!running)
			return
			
		var as = new AudioStream(this.getClass.getResourceAsStream("/de/blauerfalke/tetris/res/snd/01.wav"));         
		AudioPlayer.player.start(as);            
		//AudioPlayer.player.stop(as);

		
		for(c <- field.stone.blocks)
			field.blocks =  Block((field.stone.p._1+c.p._1,field.stone.p._2+c.p._2),c.c) :: field.blocks
				
		var line = Field.fieldHeight
		for(c <- field.blocks) if(c.p._2<line) line = c.p._2
		
		var amountLines = 0
		while(line < Field.fieldHeight) {
			var colCount=0
			for(c <- field.blocks)
				if(c.p._2 == line)
						colCount = colCount + 1
							
			if(colCount>=Field.fieldWidth) {
				DeleteAnimation(this, line);
				amountLines = amountLines + 1
				lines = lines + 1
			}
			line = line + 1
		}
		points = points + (100 * amountLines*amountLines)
				
		checkLevel
		
		field.stone = next
		next = Stone(0)
		checkGameOver
		
		if(Main.main!=null)
			Main.main.repaint
	}
	
	def delLine(line:Int) {
		field.blocks = field.blocks.filter(s => s.p._2 != line)
		field.blocks = field.blocks.map(s => if(s.p._2<line) Block((s.p._1, s.p._2+1), s.c) else s)
		
	}
	
	def checkGameOver() {
		if(checkCollision) {	//if respawn in a block the game is over ...
			timer.stop
			timer = null
			running = false
			field.stone = Stone(-1)
			field.blocks = List()
			if(points <= Highscore.minPoints) {
				Dialog.showMessage(field,"GAME OVER\n\nThe Game is over.","Game Over")
			} else {
				var o = Dialog.showInput(field,"GAME OVER\n\nThe Game is over.\n\nYou got "+points+" Points.\n\n Please Enter your Name for the Highscore:","Game Over",Dialog.Message.Plain, Swing.EmptyIcon, Seq[String](), "")
				if(o!=None) {
					Highscore.add(o.get.asInstanceOf[String],points)
					
				}
			}
			Highscore.show
			
		}
	}
	
	def checkCollision() :Boolean = {
		for(b <- field.stone.blocks) {
			val x1 = b.p._1+field.stone.p._1
			val x2 = b.p._2+field.stone.p._2
			if(x1<0 || x1>Field.fieldWidth-1)
				return true
			if(x2<0 || x2>Field.fieldHeight-1)
				return true
			for(c <- field.blocks)
				if(x1==c.p._1 && x2==c.p._2)
					return true
		}
		
		return false
		
	}
	
	val Mover = actor {
		loop {
			react {
				case "left" => { 
					field.stone.left
					if(checkCollision) { 
						field.stone.back
					}
					//repaint
				}
				case "right" => {
					field.stone.right
					if(checkCollision) { 
						field.stone.back
					}
					//repaint
				}
				case "down" => {
					field.stone.down
					if(checkCollision) { 
						field.stone.back
						if(field.stone.ground) {
							nextStone
			     	 	} else {
			     	 		field.stone.ground=true
			     	 	}
					}
					//repaint
				}
				case "turnl" => {
					field.stone.turnl
					if(checkCollision) {
						field.stone.left
						if(checkCollision) {
							field.stone.back
							field.stone.turnr
						}
					}
					//repaint
				}
				case "turnr" => {
					field.stone.turnr
					if(checkCollision) {
						field.stone.left
						if(checkCollision) {
							field.stone.back
							field.stone.turnl
						}
					}
					//repaint
				}
			}
		}

	}
	Mover.start
}