package de.blauerfalke.tetris.view

import java.awt.Color
import java.awt.Graphics

object Block {
	val blockSize = 20
	def apply(b:(Int,Int), c:Color) = new Block(b, c)
	def apply(x:Int, y:Int, c:Color) = new Block((x,y), c)
}
class Block(var p:(Int,Int),var c:Color) {
	
	def paint(g:Graphics) { paint(g,(0,0), Block.blockSize) }
	def paint(g:Graphics, gp:(Int,Int)) { paint(g,(0,0), Block.blockSize) }
	def paint(g:Graphics, gp:(Int,Int), bs:Int) {
		g.setColor(c);
		g.fillRect(p._1*bs + gp._1*bs, p._2*bs + gp._2*bs, bs, bs)
		g.setColor(Color.gray);
		g.drawRect(p._1*bs + gp._1*bs, p._2*bs + gp._2*bs, bs, bs)

		val x = p._1*bs + gp._1*bs
		val y = p._2*bs + gp._2*bs
		g.setColor(Color.gray);
		g.drawRect(x+(bs/2).asInstanceOf[Int], y+(bs/2).asInstanceOf[Int], 1, 1)

	}
}