package de.blauerfalke.tetris.view

import java.awt.Color
import java.awt.Graphics
import java.awt.Graphics2D
import java.awt.RenderingHints
import sun.audio._
import java.io.FileInputStream
import de.blauerfalke.tetris.control.Control

object DeleteAnimation {
	def apply(control:Control, line:Int) = {
		var a = new DeleteAnimation(control, line)
		animations = a :: animations
		a
	}
	def del(a:DeleteAnimation) { animations = animations - a }
	var animations:List[DeleteAnimation] = List()
	
}
class DeleteAnimation(var control:Control, var line:Int) {
	var as = new AudioStream(this.getClass.getResourceAsStream("/de/blauerfalke/tetris/res/snd/02.wav"));         
	AudioPlayer.player.start(as);
		
	var counter = 0
	def paint(g:Graphics) { paint(g,(0,0)) }
	def paint(g:Graphics, gp:(Int,Int)) {
		
		var renderHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
		renderHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
		val g2d = g.asInstanceOf[Graphics2D];
		g2d.setRenderingHints(renderHints);

		
		counter = counter + 10
		
		if(counter < 100) {
			val w:Int = ((counter / 100.0f) *Field.fieldWidth*Block.blockSize).asInstanceOf[Int]
			val h:Int = ((counter / 100.0f)*Block.blockSize).asInstanceOf[Int]
			val x:Int = ( 0+(Field.fieldWidth*Block.blockSize/2.0*(1-(counter/100.0f)))).asInstanceOf[Int] 
			val y:Int = (line * Block.blockSize + (Block.blockSize/2.0*(1-(counter / 100.0f)))).asInstanceOf[Int]
			
			g.setColor(new Color(50, 230, 230))
			g.fillOval(x,y, w, h)
			g.setColor(new Color(100, 230, 230))
			g.fillOval(x+10,y+2, w-20, h-4)
			g.setColor(new Color(150, 230, 230))
			g.fillOval(x+20,y+4, w-40, h-8)
			g.setColor(new Color(200, 230, 230))
			g.fillOval(x+40,y+6, w-80, h-12)
			g.setColor(new Color(230, 230, 230))
			g.fillOval(x+60,y+8, w-120, h-16)
		} else {
			DeleteAnimation.del(this)
			control.delLine(line)
			for(a <- DeleteAnimation.animations)
				if(a.line<line)
					a.line = a.line + 1
		}
	}
}