package de.blauerfalke.tetris.view


import scala.swing.Component
import java.awt.Graphics2D
import java.awt.Color
import java.awt.event.{ActionListener, ActionEvent}
import sun.audio._
import java.io.FileInputStream
import java.awt.Image
import java.awt.Graphics
import de.blauerfalke.tetris.control.Control
import java.awt.event.KeyListener
import java.awt.event.KeyEvent
import java.awt.event.FocusListener
import java.awt.event.FocusEvent
import java.awt.event.MouseListener
import java.awt.event.MouseEvent
import swing.MainFrame 
import scala.actors.Actor
import scala.actors.Actor._

object Field {
	val fieldWidth = 11
	val fieldHeight = 18
}
class Field extends Component {
	override lazy val peer: javax.swing.JComponent = new javax.swing.JComponent with SuperMixin {
		override def getMinimumSize() = new java.awt.Dimension(Field.fieldWidth*Block.blockSize, Field.fieldHeight*Block.blockSize)
		override def getPreferredSize() = new java.awt.Dimension(Field.fieldWidth*Block.blockSize, Field.fieldHeight*Block.blockSize)
		override def getMaximumSize() = new java.awt.Dimension(Field.fieldWidth*Block.blockSize, Field.fieldHeight*Block.blockSize)
	}
	
	val control = new Control(this)
	var stone = Stone(-1)
	var blocks:List[Block] = List()
	
	//Focus Control           if NoFocus => pause game
	peer.setFocusable(true);
	peer.addFocusListener(new FocusListener {
		def focusGained(e: FocusEvent) {  control.pause(false)}
		def focusLost(e: FocusEvent) {  control.pause(true)}

	})
	peer.addMouseListener(new MouseListener {
		def mousePressed(e:MouseEvent) {}
		def mouseReleased(e:MouseEvent) {}
		def mouseEntered(e:MouseEvent) {}
		def mouseExited(e:MouseEvent) {}
		def mouseClicked(e:MouseEvent) { peer.requestFocusInWindow }
	});
	if(!peer.hasFocus)
		control.pause(true)
	
	//Keyboard Input
	peer.addKeyListener(new KeyListener() {
		   def keyTyped(e: KeyEvent) = {  }
		   def keyPressed(e: KeyEvent) = {
		  	   if(e.getKeyCode==KeyEvent.VK_LEFT )  control.Mover ! "left"
		  	   if(e.getKeyCode==KeyEvent.VK_RIGHT ) control.Mover ! "right"
		  	   if(e.getKeyCode==KeyEvent.VK_DOWN )  control.Mover ! "down"
		  	   if(e.getKeyCode==KeyEvent.VK_SPACE ) control.Mover ! "turnl" 
		  	   if(e.getKeyCode==KeyEvent.VK_ENTER ) control.Mover ! "turnr"
		  	   if(e.getKeyCode==KeyEvent.VK_P ) 	control.pause
		   }
		   def keyReleased(e: KeyEvent) =  {}
		})
	
	//Repaint all 50 msec
	new javax.swing.Timer(50 , new ActionListener { def actionPerformed(ae:ActionEvent) { repaint } }).start
	//var t:Actor = actor { loop { reactWithin(50) { case "repaint" => {repaint; t ! "repaint" } } }  }.start; t ! "repaint"
		
		
	
	
	
	override def paintComponent(g: Graphics2D) {
		
		g.setColor(Color.black)
		g.fillRect(0,0, Field.fieldWidth*Block.blockSize ,Field.fieldHeight*Block.blockSize)
		
		if(border!=null)
			border.paintBorder(peer, g, 0,0,Field.fieldWidth*Block.blockSize,Field.fieldHeight*Block.blockSize)
		
		if(control.running) {
			if(control.paused) {
				g.setColor(Color.green)
				g.setFont(new java.awt.Font("",java.awt.Font.BOLD,20))
				g.drawString("Paused", Field.fieldWidth*Block.blockSize/2-30, Field.fieldHeight*Block.blockSize/2-10)
			
			} else {
			
				for(b <- blocks)
					b.paint(g)
				stone.paint(g)
				
				for(a <- DeleteAnimation.animations)
					a.paint(g)
			}
		}
	}
	
	/* All Swing Elements makes automatic Double-Buffering
	var dbImage:Image = null;
	var dbGraphics:Graphics = null;
	def update(g:Graphics) {
		//Double-Buffer initialisieren
		if(dbImage == null) {
			dbImage = peer.createImage(size.width,size.height);
			dbGraphics = dbImage.getGraphics();
		}
	   //Hintergrund löschen
	   dbGraphics.setColor(background);
	   dbGraphics.fillRect(0,0,size.width,size.height);
	   //Vordergrund zeichnen
	   dbGraphics.setColor(foreground);
	   paintComponent(dbGraphics.asInstanceOf[Graphics2D]);
	   //Offscreen anzeigen
	   g.drawImage(dbImage,0,0,peer);
	}*/
}