package de.blauerfalke.tetris.view

import scala.swing._
import java.awt.GridBagConstraints
import javax.swing.table.DefaultTableModel
import java.util.StringTokenizer
import java.io._

object Highscore extends Dialog(Main.main) {
	title = "Highscore"
		
	val tab = new Table(0,2){
		def addRow(data:Array[Object]) = model.asInstanceOf[DefaultTableModel].insertRow(rowCount ,data)
		def removeRow(k: Int) = model.asInstanceOf[DefaultTableModel].removeRow(k)
	}
	tab.model = new DefaultTableModel(0, 2) {
      override def setValueAt(value: Any, row: Int, col: Int) {
        super.setValueAt(value, row, col)
      }
      override def isCellEditable(i:Int,j:Int) = false
    }
	tab.peer.getColumnModel.getColumn(0).setHeaderValue("Name");
	tab.peer.getColumnModel.getColumn(1).setHeaderValue("Points");
	
	def readFile() {
		val f = new File("tetris.highscore.csv");
		if(!f.exists)
			f.createNewFile
			
		val bufRdr = new BufferedReader(new FileReader(new File("tetris.highscore.csv")));
		var line = ""
		var list:List[Array[String]] = List()
		
		while((line = bufRdr.readLine())!=null && line!=null)
			list = line.split("\\,") :: list
		
		list = list.sort((a, b) => java.lang.Integer.valueOf(a(1)).asInstanceOf[Int] > java.lang.Integer.valueOf(b(1)).asInstanceOf[Int])

		for(d <- list)
			tab.addRow(d.asInstanceOf[Array[Object]])	
	}
	readFile
	
	def save() {
		val f = new File("tetris.highscore.csv");
		if(!f.exists)
			f.createNewFile
		var s= ""
		for(i <- 0 until tab.model.getRowCount)
			s += tab.model.getValueAt(i,0)+","+tab.model.getValueAt(i,1)+"\n"
		val out = new BufferedWriter(new FileWriter("tetris.highscore.csv"));
		out.write(s);
		out.close();
	}
	def add(name:String, points:Int) { 
		tab.addRow(Array(name, ""+points).asInstanceOf[Array[Object]])
		sort
		if(tab.model.getRowCount>10)
			tab.removeRow(10)
	}

	def sort() {
		var list:List[Array[String]] = List()
		while(tab.model.getRowCount > 0) {
			list = Array(tab.model.getValueAt(0,0).asInstanceOf[String],tab.model.getValueAt(0,1).asInstanceOf[String]) :: list
			tab.removeRow(0)
		}
		list = list.sort((a, b) => java.lang.Integer.valueOf(a(1)).asInstanceOf[Int] > java.lang.Integer.valueOf(b(1)).asInstanceOf[Int])
		for(d <- list)
			tab.addRow(d.asInstanceOf[Array[Object]])	
	}
	def minPoints() = { if(tab.model.getRowCount<10) 1 else java.lang.Integer.valueOf(tab.model.getValueAt(tab.model.getRowCount-1,1).asInstanceOf[String]).asInstanceOf[Int] } 
	
	def show() { pack; peer.setVisible(true) }
	
	contents = new GridBagPanel {
	
		add( new ScrollPane(tab)		, new Constraints(0,0, 1,1,  0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH,new Insets(2,2,2,2),0,0 ))
		add( new Button(Action("Ok") { Highscore.dispose; Highscore.peer.setVisible(false); })		, new Constraints(0,1, 1,1,  0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE,new Insets(0,0,0,0),0,0 ))
	}
}