package de.blauerfalke.tetris.view

import scala.swing.Component
import java.awt.Graphics2D
import java.awt.Color

object Level {
	val width = 100
	val height = 30
}

class Level(val field:Field) extends Component {
	override lazy val peer: javax.swing.JComponent = new javax.swing.JComponent with SuperMixin {
		override def getMinimumSize()   = new java.awt.Dimension(Level.width, Level.height)
		override def getPreferredSize() = new java.awt.Dimension(Level.width, Level.height)
		override def getMaximumSize()   = new java.awt.Dimension(Level.width, Level.height)
	}
	val control = field.control
	
	override def paintComponent(g: Graphics2D) {
		if(border!=null)
			border.paintBorder(peer, g, 0,0,Level.width,Level.height)
		
		g.setColor(Color.black)
		g.fillRect(0,0, Level.width ,Level.height)
		
		if(control.running) {
			g.setColor(Color.green)
			g.setFont(new java.awt.Font("",java.awt.Font.BOLD,20))
			g.drawString("Level "+control.level,15,23)
		}
	}
}