package de.blauerfalke.tetris.view

import swing._
import javax.swing.border._
import java.awt.Color
import javax.swing.UIManager
import java.awt.GridBagConstraints
import java.awt.event.WindowAdapter
import java.awt.event.WindowEvent

object Main extends SimpleGUIApplication {
	override def main(args: Array[String]) = run {
    val t = top
    t.pack()
    t.visible = true
  }
	
	val main = new MainFrame {

		//Look and Feel
		try{
			UIManager.setLookAndFeel(new com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel);
		} catch {
			case _ => UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
		}
	 
		//Frametitle
		title="Tetris"
		//iconImage = java.awt.Toolkit.getDefaultToolkit.getImage(resourceFromClassloader("/gui/img/icon.png"))
     
		//Size und Position
		val framewidth = 380//235
		val frameheight = 470//357
		val screenSize = java.awt.Toolkit.getDefaultToolkit().getScreenSize()
		location=new java.awt.Point((screenSize.width-framewidth)/2, (screenSize.height-frameheight)/2)
		minimumSize=new java.awt.Dimension(framewidth, frameheight)
 
		val quitAction = Action("Quit") {
			
			try {
				Highscore.save
			} catch {
				case _ => 
			}
			System.exit(0)
		}
		
		peer.addWindowListener(new WindowAdapter() { override def windowClosing(we: WindowEvent) = quitAction();});

		//Menu
		menuBar = new MenuBar{
			contents += new Menu("Menu") {
				contents += new MenuItem(Action("New Game") {  f.control.start } )
				contents += new MenuItem(Action("Highscore") { try { Highscore.show } catch { case _ => Dialog.showMessage(this, "Error", "Could not show Highscore. Perhaps you have no write Permission")}} )
				contents += new MenuItem(quitAction)
				
			}
		}
	  
		val f = new Field() { border = new SoftBevelBorder(0) }
		
		contents = new GridBagPanel {
			background = Color.darkGray
			add( f 													, new Constraints(0,0, 1,3,  0.0, 0.0, GridBagConstraints.EAST, GridBagConstraints.NONE,new Insets(0,0,0,0),0,0 ))
			add( new Level(f)   { border = new SoftBevelBorder(0) }	, new Constraints(1,0, 1,1,  0.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.NONE,new Insets(0,5,5,5),0,0 ))
			add( new Points(f)  { border = new SoftBevelBorder(0) }	, new Constraints(1,1, 1,1,  0.0, 0.0, GridBagConstraints.EAST, GridBagConstraints.NONE,new Insets(5,5,5,5),0,0 ))
			add( new Preview(f)	{ border = new SoftBevelBorder(0) }	, new Constraints(1,2, 1,1,  0.0, 0.0, GridBagConstraints.NORTH, GridBagConstraints.NONE,new Insets(5,5,5,5),0,0 ))
			 
		}
		
	}
	def top = main
}