package de.blauerfalke.tetris.view

import scala.swing.Component
import java.awt.Graphics2D
import java.awt.Color

object Points {
	val width = 100
	val height = 30
}

class Points(val field:Field) extends Component {
	override lazy val peer: javax.swing.JComponent = new javax.swing.JComponent with SuperMixin {
		override def getMinimumSize()   = new java.awt.Dimension(Points.width, Points.height)
		override def getPreferredSize() = new java.awt.Dimension(Points.width, Points.height)
		override def getMaximumSize()   = new java.awt.Dimension(Points.width, Points.height)
	}
	val control = field.control
	
	override def paintComponent(g: Graphics2D) {
		if(border!=null)
			border.paintBorder(peer, g, 0,0,Points.width,Points.height)
		
		g.setColor(Color.black)
		g.fillRect(0,0, Points.width ,Points.height)
		if(control.running) {
			g.setColor(Color.green)
			g.drawString( String.format("%#20s",""+control.points),20,20)
		}
	}
}