package de.blauerfalke.tetris.view

import scala.swing.Component
import java.awt.Graphics2D
import java.awt.Color
object Preview {
	val blockSize = 10
}
class Preview(val field:Field) extends Component {
	override lazy val peer: javax.swing.JComponent = new javax.swing.JComponent with SuperMixin {
		override def getMinimumSize()   = new java.awt.Dimension(Preview.blockSize*4, Preview.blockSize*6)
		override def getPreferredSize() = new java.awt.Dimension(Preview.blockSize*4, Preview.blockSize*6)
		override def getMaximumSize()   = new java.awt.Dimension(Preview.blockSize*4, Preview.blockSize*6)
	}
	val control = field.control
	control.preview = this
	
	override def paintComponent(g: Graphics2D) {
		if(border!=null)
			border.paintBorder(peer, g, 0,0,Preview.blockSize*4 ,Preview.blockSize*6)
		
		g.setColor(Color.black)
		g.fillRect(0,0, Preview.blockSize*4 ,Preview.blockSize*6)
		
		if(!control.paused && control.running)
			control.next.paint(g,(1,1), Preview.blockSize)
	}
}