package de.blauerfalke.tetris.view

import java.awt.Graphics
import java.awt.Color
import java.util.Random

object Stone {
	
	def apply(typ:Int) = {
		var t = typ match { case 0 => new Random(System.currentTimeMillis()).nextInt(7) + 1; case _ => typ }
	
		t match {
			case -1 => new Stone(Array())
			case 1 => new Stone(Array( Block(0,0,Color.blue)  ,Block(0,1,Color.blue)  ,Block(0,2,Color.blue)  ,Block(1,2, Color.blue) ))
			case 2 => new Stone(Array( Block(1,0,Color.green) ,Block(1,1,Color.green) ,Block(1,2,Color.green) ,Block(0,2,Color.green) ))
			case 3 => new Stone(Array( Block(0,0,Color.red)   ,Block(0,1,Color.red)   ,Block(1,1,Color.red)   ,Block(1,2,Color.red)   ))
			case 4 => new Stone(Array( Block(1,0,Color.orange),Block(1,1,Color.orange),Block(0,1,Color.orange),Block(0,2,Color.orange)))
			case 5 => new Stone(Array( Block(1,0,Color.pink)  ,Block(1,1,Color.pink)  ,Block(0,1,Color.pink)  ,Block(1,2,Color.pink)  ))
			case 6 => new Stone(Array( Block(0,0,Color.yellow),Block(1,0,Color.yellow),Block(0,1,Color.yellow),Block(1,1,Color.yellow)))
			case 7 => new Stone(Array( Block(0,0,Color.cyan)  ,Block(0,1,Color.cyan)  ,Block(0,2,Color.cyan)  ,Block(0,3,Color.cyan)  ))
		}
	}
}

class Stone(var blocks:Array[Block]) {
	var p = (4,0)		//position
	var lp = (0,0)		//last position
	var ground = false	//was the last time on the ground?
	
	def matrixMult(p:(Int,Int),m:((Int,Int, Int,Int))) = {
		(p._1*m._1+p._2*m._2,p._1*m._3+p._2*m._4)
	}
	
	def turnl() { 
		var min = (1000,1000)
		for(i <- 0 until blocks.size) {
			blocks(i).p = matrixMult(blocks(i).p, (0,-1, 1,0) )
			if(blocks(i).p._1 < min._1) min = (blocks(i).p._1,min._2)
			if(blocks(i).p._2 < min._2) min = (min._1, blocks(i).p._2)
		}
		for(i <- 0 until blocks.size)
			blocks(i).p = (blocks(i).p._1 - min._1, blocks(i).p._2 - min._2)
	}
	def turnr() { 
		var min = (1000,1000)
		for(i <- 0 until blocks.size) {
			blocks(i).p = matrixMult(blocks(i).p, (0,1, -1,0) )
			if(blocks(i).p._1 < min._1) min = (blocks(i).p._1,min._2)
			if(blocks(i).p._2 < min._2) min = (min._1, blocks(i).p._2)
		}
		for(i <- 0 until blocks.size)
			blocks(i).p = (blocks(i).p._1 - min._1, blocks(i).p._2 - min._2)
	}
	def down() { 
		lp = p
		p = (p._1, p._2+1) 
	}
	def left() {
		lp = p
		p = (p._1-1, p._2) 
	}
	def right() {
		lp = p
		p = (p._1+1, p._2) 
	}
	def back = p = lp
	
	def paint(g:Graphics) { paint(g, p, Block.blockSize) }
	def paint(g:Graphics, p:(Int,Int)) { paint(g, p, Block.blockSize) }
	def paint(g:Graphics, p:(Int,Int), bs:Int) {
		for(b <- blocks)
			b.paint(g, p, bs)	
	}
}